package ru.yandex.webmaster3.coordinator.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;

import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.util.IdUtils;

/**
 * @author aherman
 */
public abstract class AbstarctUpdateArchiveAction<Req extends AbstarctUpdateArchiveRequest, Resp extends AbstarctUpdateArchiveAction.NormalResponse>
        extends BaseCoordinatorAction<Req, AbstarctUpdateArchiveAction.NormalResponse>
{
    private static final Logger log = LoggerFactory.getLogger(AbstarctUpdateArchiveAction.class);
    private static final int BATCH_SIZE = 1024;

    private File dataFolder;

    @Override
    public NormalResponse process(Req request) throws WebmasterException {
        // игнорируем все, сразу отдаем 200
/*        DateTime archiveDate = ConverterUtils.toDateTime(request.getDataTimestamp());
        log.info("Host list updated: type={} dataTimestamp={} ", getListType(), archiveDate);
        File hostListFile = createHostListFile(dataFolder, request.getDataTimestamp());
        File tmpHostListFile = createTmpFile(hostListFile);
        if (tmpHostListFile.exists()) {
            log.info("File already exists, remove: {}", tmpHostListFile.getAbsolutePath());
            if (!tmpHostListFile.delete()) {
                String message = "Unable to delete file: " + tmpHostListFile.getAbsolutePath();
                throw new WebmasterException(message,
                        new WebmasterErrorResponse.InternalUnknownErrorResponse(this.getClass(), message)
                );
            }
        }

        try (OutputStream os = new BufferedOutputStream(new FileOutputStream(tmpHostListFile))) {
            int size = IOUtils.copy(request.getContentInputStream(), os);
            log.info("Hosts saved: {} {}" , tmpHostListFile.getAbsolutePath(), size);
        } catch (IOException e) {
            log.error("Unable to save file", e);
            String message = "Unable to save hosts file: " + tmpHostListFile.getAbsolutePath();
            throw new WebmasterException(message,
                    new WebmasterErrorResponse.InternalUnknownErrorResponse(this.getClass(), message),
                    e
            );
        }
        if (!tmpHostListFile.renameTo(hostListFile)) {
            log.error("Unable to rename: {} to {}", tmpHostListFile.getAbsolutePath(), hostListFile.getAbsolutePath());
        }

        updateHostList(hostListFile, archiveDate);*/
        return new NormalResponse();
    }

    protected abstract HostListType getListType();
    protected abstract void save(List<Pair<WebmasterHostId,DateTime>> batch);

    protected void updateHostList(File hostListFile, DateTime archiveDate) {
        try (BufferedReader hostsReader = new BufferedReader(
                new InputStreamReader(new GZIPInputStream(new FileInputStream(hostListFile)), StandardCharsets.UTF_8)
        ))
        {
            List<Pair<WebmasterHostId, DateTime>> batch = new ArrayList<>();
            String line;
            int hostCount = 0;
            while ((line = hostsReader.readLine()) != null) {
                WebmasterHostId hostId = IdUtils.urlToHostId(line);
                batch.add(Pair.of(hostId, archiveDate));
                if (batch.size() >= BATCH_SIZE) {
                    save(batch);
                    batch.clear();
                }
                hostCount++;
                if (hostCount % 50000 == 0) {
                    log.info("Hosts updated: {} {}", hostCount, hostId);
                }
            }
            if (batch.size() > 0) {
                save(batch);
            }
            log.info("Host archive updated: {}", hostCount);
        } catch (IOException e) {
            String message = "Unable to update host archive: " + getListType();
            throw new WebmasterException(message,
                    new WebmasterErrorResponse.InternalUnknownErrorResponse(this.getClass(), message), e);
        }
    }

    protected File createHostListFile(File dataFolder, int dataTimestamp) {
        return new File(dataFolder, "hostList" + "." + getListType().name().toLowerCase() + "." + dataTimestamp + "." + "hosts");
    }

    private File createTmpFile(File hostListFile) {
        return new File(hostListFile.getParentFile(), hostListFile.getName() + ".tmp");
    }

    protected static enum HostListType {
        URL_ARCHIVE,
        EXTERNAL_LINKS_ARCHIVE,
        INTERNAL_LINKS_ARCHIVE,
    }

    public static class NormalResponse implements ActionResponse.NormalResponse {
    }

    @Required
    public void setDataFolder(File dataFolder) {
        this.dataFolder = dataFolder;
    }
}
