package ru.yandex.webmaster3.coordinator.http.feeds;

import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.Value;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.Header;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.zora.GoZoraService;
import ru.yandex.webmaster3.core.zora.go_data.request.GoZoraRequest;


/**
 * @author kravchenko99
 * @date 12/13/21
 */

@Slf4j
@Component("/check/gozora")
@WriteAction
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Category("cord")
public class CheckGoZora extends Action<CheckGoZora.Req, CheckGoZora.Res> {
    private final GoZoraService goZoraService;

    @Override
    public Res process(Req request) throws WebmasterException {
        Header[] headers =
                goZoraService.executeRequest(new GoZoraRequest(request.url, false, true, false)).getHeaders();
        log.info("lol - {}" , headers);
        return new Res();
    }

    @Setter(onMethod_ = @RequestQueryProperty)
    public static class Req implements ActionRequest {
        String url;
    }

    @Value
    public static class Res implements ActionResponse.NormalResponse {

    }
}
