package ru.yandex.webmaster3.coordinator.http.host;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.coordinator.http.BaseCoordinatorAction;
import ru.yandex.webmaster3.coordinator.http.BaseCoordinatorRequest;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.events2.HostEvent;
import ru.yandex.webmaster3.core.events2.client.HostEventLogClient;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.http.RequestPostProperty;

import java.util.concurrent.TimeUnit;

/**
 * @author avhaliullin
 */
public class AddHostEventAction extends BaseCoordinatorAction<AddHostEventAction.Req, AddHostEventAction.Res> {
    private HostEventLogClient hostEventLogClient;

    @Override
    public Res process(Req request) throws WebmasterException {
        hostEventLogClient.log(request.event);
        return new Res();
    }

    @Required
    public void setHostEventLogClient(HostEventLogClient hostEventLogClient) {
        this.hostEventLogClient = hostEventLogClient;
    }

    public static class Req implements BaseCoordinatorRequest {
        private String applicationName;
        private String applicationVersion;
        private String requestId;
        private HostEvent event;

        @Override
        public String getApplicationName() {
            return applicationName;
        }

        @Override
        public void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public String getApplicationVersion() {
            return applicationVersion;
        }

        @Override
        public void setApplicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        @Override
        public String getRequestId() {
            return requestId;
        }

        @Override
        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public HostEvent getEvent() {
            return event;
        }

        @RequestPostProperty(required = true)
        public void setEvent(HostEvent event) {
            this.event = event;
        }
    }

    public static class Res implements ActionResponse.NormalResponse {
    }
}
