package ru.yandex.webmaster3.coordinator.http.migration;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WriteAction;

//        пример миграции TTL-ной таблицы
@WriteAction
@RequiredArgsConstructor(onConstructor_ = @Autowired)
//@Component("/migrate/tmp/migrateHostThreatRecheckButtonStateAction")
public class MigrateHostThreatRecheckButtonStateAction extends Action<MigrateHostThreatRecheckButtonStateAction.Req, MigrateHostThreatRecheckButtonStateAction.Res> {

//    private final HostThreatRecheckButtonStateCDao hostThreatRecheckButtonStateCDao;
//    private final HostThreatRecheckButtonStateYDao hostThreatRecheckButtonStateYDao;

    @Override
    public Res process(Req request) throws WebmasterException {
//        var list = hostThreatRecheckButtonStateCDao.getRecords();
//        list.forEach(record -> {
//            hostThreatRecheckButtonStateYDao.insertRecord(
//                    record.webmasterHostId,
//                    record.threat,
//                    record.recheckDate,
//                    record.requestHostId,
//                    record.requestUserId,
//                    record.ttl
//                    );
//        });
        return new Res();

        /* HostThreatRecheckButtonStateCDao:
        public List<Rec> getRecords()  {
            var qb = QueryBuilder
                    .select("threat_source_host_id",
                            "threat",
                            "recheck_date",
                            "request_host_id",
                            "request_user_id",
                            QueryBuilder.fcall("ttl", QueryBuilder.raw("request_host_id"))) // ttl(request_host_id)
                    .from(KEYSPACE_WEBMASTER_3, TABLE_NAME)
                    .setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
            return queryAll(qb, Rec::new);
        }


        @Value
        @ToString
        public class Rec {
            public WebmasterHostId webmasterHostId;
            public String threat;
            public DateTime recheckDate;
            public WebmasterHostId requestHostId;
            public Long requestUserId;
            public Duration ttl;

            public Rec(Row row) {
                webmasterHostId = IdUtils.stringToHostId(row.getString("threat_source_host_id"));
                threat = row.getString("threat");
                recheckDate = getDate(row,"recheck_date");
                requestHostId =  IdUtils.stringToHostId(row.getString("request_host_id"));
                requestUserId = row.getLong("request_user_id");
                ttl = Duration.standardSeconds(row.getInt("ttl(request_host_id)"));
            }
        }

         */
    }

    public static class Req implements ActionRequest {
    }

    public static class Res implements ActionResponse.NormalResponse {

    }
}
