package ru.yandex.webmaster3.coordinator.http.old.wmc.api;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.core.http.*;
import ru.yandex.webmaster3.storage.sitemap.UserSitemapService;

import java.net.URL;

/**
 * @author avhaliullin
 */
public class OldWmAddUserSitemapAction extends Action<OldWmAddUserSitemapAction.Request, OldWmAddUserSitemapAction.Response> {
    private UserSitemapService userSitemapService;

    @Override
    public Response process(Request request) throws WebmasterException {
        userSitemapService.addUserSitemap(request.hostId, request.sitemapUrl.toExternalForm(), new WebmasterUser(request.userId));
        return new Response();
    }

    @Required
    public void setUserSitemapService(UserSitemapService userSitemapService) {
        this.userSitemapService = userSitemapService;
    }

    public static class Request implements ActionRequest {
        private WebmasterHostId hostId;
        private long userId;
        private URL sitemapUrl;

        @RequestQueryProperty(required = true)
        public void setHostId(WebmasterHostId hostId) {
            this.hostId = hostId;
        }

        @RequestQueryProperty(required = true)
        public void setUserId(long userId) {
            this.userId = userId;
        }

        @RequestQueryProperty(required = true)
        public void setSitemapUrl(URL sitemapUrl) {
            this.sitemapUrl = sitemapUrl;
        }
    }

    public static class Response implements ActionResponse.NormalResponse {
    }
}
