package ru.yandex.webmaster3.coordinator.http.old.wmc.api;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.*;
import ru.yandex.webmaster3.core.sitemap.UserSitemap;
import ru.yandex.webmaster3.storage.sitemap.UserSitemapService;

import java.util.List;

/**
 * @author avhaliullin
 */
public class OldWmListUserSitemapsAction extends Action<OldWmListUserSitemapsAction.Request, OldWmListUserSitemapsAction.Response> {
    private UserSitemapService userSitemapService;

    @Override
    public Response process(Request request) throws WebmasterException {
        List<UserSitemap> userSitemaps = userSitemapService.listUserSitemaps(request.hostId);
        return new Response(userSitemaps);
    }

    @Required
    public void setUserSitemapService(UserSitemapService userSitemapService) {
        this.userSitemapService = userSitemapService;
    }

    public static class Request implements ActionRequest {
        private WebmasterHostId hostId;

        @RequestQueryProperty(required = true)
        public void setHostId(WebmasterHostId hostId) {
            this.hostId = hostId;
        }
    }

    public static class Response implements ActionResponse.NormalResponse {
        public final List<UserSitemap> sitemaps;

        public Response(List<UserSitemap> sitemaps) {
            this.sitemaps = sitemaps;
        }
    }
}
