package ru.yandex.webmaster3.coordinator.http.old.wmc.api;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.sitemap.UserSitemapService;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class OldWmRemoveUserSitemapAction extends Action<OldWmRemoveUserSitemapAction.Request, OldWmRemoveUserSitemapAction.Response> {
    private UserSitemapService userSitemapService;

    @Override
    public Response process(Request request) throws WebmasterException {
        userSitemapService.deleteUserSitemap(request.hostId, request.sitemapId);
        return new Response();
    }

    @Required
    public void setUserSitemapService(UserSitemapService userSitemapService) {
        this.userSitemapService = userSitemapService;
    }

    public static class Request implements ActionRequest {
        private WebmasterHostId hostId;
        private UUID sitemapId;

        @RequestQueryProperty(required = true)
        public void setHostId(WebmasterHostId hostId) {
            this.hostId = hostId;
        }

        @RequestQueryProperty(required = true)
        public void setSitemapId(UUID sitemapId) {
            this.sitemapId = sitemapId;
        }
    }

    public static class Response implements ActionResponse.NormalResponse {
    }
}
