package ru.yandex.webmaster3.coordinator.http.sitestructure;

import java.io.InputStream;

import ru.yandex.webmaster3.coordinator.ReceiverStatusService;
import ru.yandex.webmaster3.coordinator.http.AbstractReceiveRequest;

/**
 * @author aherman
 */
public class ReceiveSiteStructureRequest implements AbstractReceiveRequest {
    private String applicationName;
    private String applicationVersion;
    private String requestId;
    private InputStream contentInputStream;

    @Override
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public String getApplicationName() {
        return applicationName;
    }

    @Override
    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    @Override
    public String getApplicationVersion() {
        return applicationVersion;
    }

    @Override
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @Override
    public String getRequestId() {
        return requestId;
    }

    @Override
    public void setContentInputStream(InputStream inputStream) {
        contentInputStream = inputStream;
    }

    @Override
    public InputStream getContentInputStream() {
        return contentInputStream;
    }

    @Override
    public ReceiverStatusService.ReceiverType getReceiveType() {
        return ReceiverStatusService.ReceiverType.SITE_STRUCTURE;
    }
}
