package ru.yandex.webmaster3.coordinator.http.sitestructure;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author aherman
 */
public abstract class ReceiveSiteStructureResponse implements ActionResponse {
    public static class NormalResponse extends ReceiveSiteStructureResponse implements ActionResponse.NormalResponse {
    }

    public static class ErrorResponse extends ReceiveSiteStructureResponse implements ActionResponse.ErrorResponse {
        public enum Error {
            GENERIC_ERROR
        }

        @Override
        public Enum<?> getCode() {
            return Error.GENERIC_ERROR;
        }
    }
}
