package ru.yandex.webmaster3.coordinator.http.sitetree;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;

import java.io.IOException;
import java.io.InputStream;

/**
 * @author aherman
 */
public class ReceivePageSamplesAction extends Action<ReceivePageSamplesRequest, ReceivePageSamplesResponse> {
    private static final Logger log = LoggerFactory.getLogger(ReceivePageSamplesAction.class);

    @Override
    public ReceivePageSamplesResponse process(ReceivePageSamplesRequest request) throws WebmasterException {
        InputStream contentInputStream = request.getContentInputStream();
        try {
            int toSkip = 1024 * 1024 * 1024;
            long size = IOUtils.skip(contentInputStream, toSkip);
            log.info("Read {} bytes", size);
        } catch (IOException e) {
            log.error("Unable to read data", e);
            IOUtils.closeQuietly(contentInputStream);
        }
        return new ReceivePageSamplesResponse();
    }
}
