package ru.yandex.webmaster3.coordinator.http.status;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.webmaster3.coordinator.ReceiverStatusService;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;

/**
 * @author aherman
 */
public class ChangeReceiverStatusAction
        extends Action<ChangeReceiverStatusAction.Request,ChangeReceiverStatusAction.Response>
{
    private ReceiverStatusService receiverStatusService;

    @Override
    public Response process(Request request) throws WebmasterException {
        receiverStatusService.changeReceiverStatus(request.getReceiverType(), request.getStatus());
        return new Response();
    }

    public static class Request implements ActionRequest {
        private ReceiverStatusService.ReceiverType receiverType;
        private boolean status;

        public ReceiverStatusService.ReceiverType getReceiverType() {
            return receiverType;
        }

        @RequestQueryProperty(required = true)
        public void setReceiverType(ReceiverStatusService.ReceiverType receiverType) {
            this.receiverType = receiverType;
        }

        public boolean getStatus() {
            return status;
        }

        @RequestQueryProperty(required = true)
        public void setStatus(boolean status) {
            this.status = status;
        }
    }

    public static class Response implements ActionResponse.NormalResponse {
    }

    @Required
    public void setReceiverStatusService(ReceiverStatusService receiverStatusService) {
        this.receiverStatusService = receiverStatusService;
    }
}
