package ru.yandex.webmaster3.coordinator.http.status;

import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.coordinator.ReceiverStatusService;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author aherman
 */
public class GetReceiverStatusAction extends Action<GetReceiverStatusAction.Request, GetReceiverStatusAction.Response> {
    private ReceiverStatusService receiverStatusService;

    @Override
    public Response process(Request request) throws WebmasterException {
        Map<ReceiverStatusService.ReceiverType, ReceiverStatusService.ReceiverStatus> status =
                receiverStatusService.getStatus();

        List<Response.Status> result = new ArrayList<>();
        for (ReceiverStatusService.ReceiverType receiverType : ReceiverStatusService.ReceiverType.values()) {
            ReceiverStatusService.ReceiverStatus receiverStatus = status.get(receiverType);
            result.add(new Response.Status(receiverType, receiverStatus.getDisableDate(),
                    receiverStatus.getMessageReceived(), receiverStatus.getMessageSkipped(),
                    receiverStatus.getMessageProcessed()));
        }
        return new Response(result);
    }

    public static class Request implements ActionRequest {}

    public static class Response implements ActionResponse.NormalResponse {
        private final List<Status> status;

        public Response(List<Status> status) {
            this.status = status;
        }

        public List<Status> getStatus() {
            return status;
        }

        public static class Status {
            private final ReceiverStatusService.ReceiverType receiverType;
            private final DateTime disableDate;
            private final long received;
            private final long skipped;
            private final long processed;

            public Status(ReceiverStatusService.ReceiverType receiverType, DateTime disableDate, long received,
                    long skipped, long processed)
            {
                this.receiverType = receiverType;
                this.disableDate = disableDate;
                this.received = received;
                this.skipped = skipped;
                this.processed = processed;
            }

            public ReceiverStatusService.ReceiverType getType() {
                return receiverType;
            }

            public DateTime getDisableDate() {
                return disableDate;
            }

            public boolean isEnabled() {
                return this.disableDate == null;
            }

            public long getReceived() {
                return received;
            }

            public long getSkipped() {
                return skipped;
            }

            public long getProcessed() {
                return processed;
            }

            public long getFailed() {
                return received - skipped - processed;
            }
        }
    }

    @Required
    public void setReceiverStatusService(ReceiverStatusService receiverStatusService) {
        this.receiverStatusService = receiverStatusService;
    }
}
