package ru.yandex.webmaster3.core;

import ru.yandex.webmaster3.core.http.ActionResponse;

/**
 * @author aherman
 */
public class WebmasterException extends RuntimeException {
    private final ActionResponse.ErrorResponse error;

    public WebmasterException(String message, ActionResponse.ErrorResponse error) {
        super(message);
        this.error = error;
    }

    public WebmasterException(String message, ActionResponse.ErrorResponse error, Throwable cause) {
        super(message, cause);
        this.error = error;
    }

    public ActionResponse.ErrorResponse getError() {
        return error;
    }
}
