package ru.yandex.webmaster3.core.addurl;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.util.IdUtils;

import static ru.yandex.webmaster3.core.addurl.AddUrlBanState.*;

/**
 * Created by Oleg Bazdyrev on 22/09/2017.
 */
public class AddUrlSpamInfo {

    private final String owner;
    private final String punycodeOwner;
    private final DateTime banDate;
    private final AddUrlBanState banState;
    private final DateTime unbanDate;
    private final String comment;

    public AddUrlSpamInfo(String owner, DateTime banDate, AddUrlBanState banState, DateTime unbanDate, String comment) {
        this.owner = owner;
        this.punycodeOwner = IdUtils.IDN.toUnicode(owner);
        this.banDate = banDate;
        this.banState = banState;
        this.unbanDate = unbanDate;
        this.comment = comment;
    }

    public String getOwner() {
        return owner;
    }

    public String getPunycodeOwner() {
        return punycodeOwner;
    }

    public DateTime getBanDate() {
        return banDate;
    }

    public AddUrlBanState getBanState() {
        return banState;
    }

    public DateTime getUnbanDate() {
        return unbanDate;
    }

    public String getComment() {
        return comment;
    }

    public static AddUrlSpamInfo ban(AddUrlSpamInfo cur, String owner, DateTime banDate) {
        AddUrlBanState banState = cur != null && cur.getBanState() == UNBANNED ? REBANNED : BANNED;
        return new AddUrlSpamInfo(owner, banDate, banState, cur == null ? null : cur.unbanDate, cur == null ? null : cur.comment);
    }

    public static AddUrlSpamInfo unban(AddUrlSpamInfo cur, String comment) {
        return new AddUrlSpamInfo(cur.owner, cur.banDate, UNBANNED, DateTime.now(), comment);
    }
}
