package ru.yandex.webmaster3.core.addurl;

/**
 * @author aherman
 */
public class RecrawlServiceException extends Exception {

    private final boolean recoverableError;

    public RecrawlServiceException(String message) {
        this(message, null, true);
    }


    public RecrawlServiceException(String message, boolean recoverableError) {
        this(message, null, recoverableError);
    }

    public RecrawlServiceException(String message, Throwable cause) {
        this(message, cause, true);
    }

    public RecrawlServiceException(String message, Throwable cause, boolean recoverableError) {
        super(message, cause);
        this.recoverableError = recoverableError;
    }

    public boolean isRecoverableError() {
        return recoverableError;
    }
}
