package ru.yandex.webmaster3.core.addurl;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author aherman
 */
public enum  RecrawlState implements IntEnum {
    UNKNOWN(0),

    NEW(1),
    IN_PROGRESS(2),
    PROCESSED(3),
    STALE(4),
    ;

    private final int value;

    RecrawlState(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public boolean isTerminal() {
        return this == PROCESSED || this == STALE;
    }

    public static final IntEnumResolver<RecrawlState> R = IntEnumResolver.r(RecrawlState.class);
}
