package ru.yandex.webmaster3.core.addurl;

import org.joda.time.DateTime;

import java.util.UUID;

/**
 * Created by ifilippov5 on 30.10.17.
 */
public class UrlRecrawlEventLog {
    private final UUID urlId;
    private final String fullUrl;
    private final DateTime updateDate;
    private final RecrawlSendingStatus status;
    private final String userIp;
    private final Long userId;

    public UrlRecrawlEventLog(UUID urlId, String fullUrl, DateTime updateDate,
                              RecrawlSendingStatus status, String userIp, Long userId) {
        this.urlId = urlId;
        this.fullUrl = fullUrl;
        this.updateDate = updateDate;
        this.status = status;
        this.userIp = userIp;
        this.userId = userId;
    }

    public UUID getUrlId() {
        return urlId;
    }

    public String getFullUrl() {
        return fullUrl;
    }

    public DateTime getUpdateDate() {
        return updateDate;
    }

    public RecrawlSendingStatus getStatus() {
        return status;
    }

    public String getUserIp() {
        return userIp;
    }

    public Long getUserId() {
        return userId;
    }

    @Override
    public String toString() {
        return fullUrl;
    }
}
