package ru.yandex.webmaster3.core.antispam.sanctions.data;

import java.util.Comparator;

import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * User: azakharov
 * Date: 09.07.15
 * Time: 14:31
 */
public enum AntispamSanctionEffectEnum {
    @Description("Исключение из поиска")
    REMOVE_FROM_SEARCH(0),
    @Description("Исключение из поиска или понижение в результатах поиска")
    REMOVE_FROM_SEARCH_OR_PESSIMIZATION(1),
    @Description("Понижение в результатах поиска")
    PESSIMIZATION(2),
    @Description("Понижение в результатах поиска и обнуление ТИЦ")
    PESSIMIZATION_AND_TCI_ZEROING(3),

    @Description("Понижение в результатах поиска и исключение из Мобильный выдачи")
    PESSIMIZATION_AND_REMOVE_FROM_GSM_SEARCH(4),

    @Description("Исключение из Мобильный выдачи")
    REMOVE_FROM_GSM_SEARCH(5),
    ;

    private final int priority;

    AntispamSanctionEffectEnum(int priority) {
        this.priority = priority;
    }

    public static final Comparator<AntispamSanctionEffectEnum> byEffect = (x, y) -> Integer.compare(x.priority, y.priority);
}
