package ru.yandex.webmaster3.core.antispam.sanctions.data;

import java.util.Comparator;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * Antispam sanction types.
 * see https://wiki.yandex-team.ru/support/platons/antispam/wmsanctions for details
 *
 * User: azakharov
 * Date: 10.06.15
 * Time: 17:13
 */
public enum AntispamSanctionEnum implements IntEnum, Comparable<AntispamSanctionEnum> {
    @Description("Накрутка поведенческих факторов")
    ANTI_PF(0, AntispamSanctionEffectEnum.PESSIMIZATION),

    @Description("Размещение на страницах сайта информации о товарах и услугах, " +
            "предоставляемых другими сайта в рамках партнерской программы. " +
            "Как правило, такие сайты не имеют ценности для пользователя, поскольку не имеют оригинального контента")
    AFFILIATE_PROGRAM(1, AntispamSanctionEffectEnum.REMOVE_FROM_SEARCH_OR_PESSIMIZATION),

    @Description("Размещение на страницах сайта невидимого или слабовидимого текста с ключевыми словами, " +
            "с целью повлиять на ранжирование в поисковой системе.")
    HIDDEN_TEXT(2, AntispamSanctionEffectEnum.REMOVE_FROM_SEARCH),

    @Description("Размещение на страницах сайта тестовых элементов, предназначенных не для посетителей сайта, " +
            "а исключительно для роботов поисковых машин.")
    KEY_WORD_STUFFING(3, AntispamSanctionEffectEnum.REMOVE_FROM_SEARCH, AntispamSanctionGroupEnum.KEY_WORD_STUFFING, 1),

    @Description("Продвижение с помощью SEO-ссылок")
    MINUSINSK(4, AntispamSanctionEffectEnum.PESSIMIZATION),

    @Description("Размещение на страницах сайта, так называемых, переоптимизированных текстов")
    OVER_OPTIMIZATION(5, AntispamSanctionEffectEnum.PESSIMIZATION, AntispamSanctionGroupEnum.OVEROPTIMIZATION, 0),

    @Description("Понижение в результатах поиска, аннулирование ТИЦ")
    AGSM_SHMEL(6, AntispamSanctionEffectEnum.PESSIMIZATION_AND_TCI_ZEROING),

    @Description("Использование на сайте невидимых элементов для clickjacking")
    CLICKJACKING(7, AntispamSanctionEffectEnum.PESSIMIZATION),

    @Description("Фрод для мобильной выдачи")
    GSMFRAUD1(8, AntispamSanctionEffectEnum.PESSIMIZATION_AND_REMOVE_FROM_GSM_SEARCH, AntispamSanctionGroupEnum.GSMFRAUD, 1),

    @Description("Фрод для мобильной выдачи")
    GSMFRAUD2(9, AntispamSanctionEffectEnum.REMOVE_FROM_GSM_SEARCH, AntispamSanctionGroupEnum.GSMFRAUD, 0),

//    @Description("Размещение на страницах сайта тестовых элементов, предназначенных не для посетителей сайта, " +
//            "а исключительно для роботов поисковых машин.")
//    KEY_WORD_STUFFING2(10, AntispamSanctionEffectEnum.PESSIMIZATION, AntispamSanctionGroupEnum.KEY_WORD_STUFFING, 0),

    @Description("Размещение на страницах сайта тестовых элементов, предназначенных не для посетителей сайта, " +
            "а исключительно для роботов поисковых машин.")
    KEY_WORD_STUFFING3(11, AntispamSanctionEffectEnum.REMOVE_FROM_SEARCH, AntispamSanctionGroupEnum.KEY_WORD_STUFFING, 1),

    @Description("Дорвеи")
    DOORWAY1(12, AntispamSanctionEffectEnum.REMOVE_FROM_SEARCH, AntispamSanctionGroupEnum.DOORWAY, 0),
    @Description("Дорвеи")
    DOORWAY2(13, AntispamSanctionEffectEnum.REMOVE_FROM_SEARCH, AntispamSanctionGroupEnum.DOORWAY, 0),
    @Description("Дорвеи")
    DOORWAY106(14, AntispamSanctionEffectEnum.REMOVE_FROM_SEARCH, AntispamSanctionGroupEnum.DOORWAY, 0),

    @Description("Клоакинг")
    CLOAKING(15, AntispamSanctionEffectEnum.REMOVE_FROM_SEARCH),

    @Description("Поисковый спам")
    SPAM7(16, AntispamSanctionEffectEnum.PESSIMIZATION, AntispamSanctionGroupEnum.SPAM, 0),
    @Description("Поисковый спам")
    SPAM15(17, AntispamSanctionEffectEnum.PESSIMIZATION, AntispamSanctionGroupEnum.SPAM, 0),
    @Description("Поисковый спам")
    SPAM16(18, AntispamSanctionEffectEnum.PESSIMIZATION, AntispamSanctionGroupEnum.SPAM, 0),

    @Description("Поисковый спам")
    SPAM61(19, AntispamSanctionEffectEnum.REMOVE_FROM_SEARCH, AntispamSanctionGroupEnum.SPAM, 1),
    @Description("Поисковый спам")
    SPAM67(20, AntispamSanctionEffectEnum.REMOVE_FROM_SEARCH, AntispamSanctionGroupEnum.SPAM, 1),
    @Description("Поисковый спам")
    SPAM102(21, AntispamSanctionEffectEnum.REMOVE_FROM_SEARCH, AntispamSanctionGroupEnum.SPAM, 1),

    @Description("Малополезный контент, спам, избыток рекламы")
    SBSPAM25(22, AntispamSanctionEffectEnum.REMOVE_FROM_SEARCH, AntispamSanctionGroupEnum.SPAM, 1),

    @Description("Малополезный контент, спам, избыток рекламы")
    SBSPAM41(23, AntispamSanctionEffectEnum.PESSIMIZATION, AntispamSanctionGroupEnum.SPAM, 0),

    @Description("Переоптимизация")
    OVER_OPTIMIZATION28(24, AntispamSanctionEffectEnum.PESSIMIZATION, AntispamSanctionGroupEnum.OVEROPTIMIZATION, 0),

    @Description("Малополезный контент, спам, избыток рекламы")
    SPAM50(25, AntispamSanctionEffectEnum.PESSIMIZATION, AntispamSanctionGroupEnum.SPAM, 0),
    @Description("Малополезный контент, спам, избыток рекламы")
    SPAM58(26, AntispamSanctionEffectEnum.PESSIMIZATION, AntispamSanctionGroupEnum.SPAM, 0),
    @Description("Малополезный контент, спам, избыток рекламы")
    SPAM82(27, AntispamSanctionEffectEnum.PESSIMIZATION, AntispamSanctionGroupEnum.SPAM, 0),
    @Description("Малополезный контент, спам, избыток рекламы")
    SPAM59(28, AntispamSanctionEffectEnum.PESSIMIZATION, AntispamSanctionGroupEnum.SPAM, 0),

    @Description("Малополезный контент, спам, избыток рекламы")
    SPAM150(29, AntispamSanctionEffectEnum.REMOVE_FROM_SEARCH, AntispamSanctionGroupEnum.SPAM, 1),
    @Description("Малополезный контент, спам, избыток рекламы")
    SPAM152(30, AntispamSanctionEffectEnum.REMOVE_FROM_SEARCH, AntispamSanctionGroupEnum.SPAM, 1),
    @Description("Малополезный контент, спам, избыток рекламы")
    SPAM154(31, AntispamSanctionEffectEnum.REMOVE_FROM_SEARCH, AntispamSanctionGroupEnum.SPAM, 1),

    @Description("Дорвей")
    // !!! Это не опечатка - SPAM136 - это про довей !!!
    SPAM136(32, AntispamSanctionEffectEnum.REMOVE_FROM_SEARCH, AntispamSanctionGroupEnum.DOORWAY, 0),
    @Description("Дорвей")
    SPAM133(33, AntispamSanctionEffectEnum.REMOVE_FROM_SEARCH, AntispamSanctionGroupEnum.DOORWAY, 0),
    ;

    private final int id;
    private final AntispamSanctionEffectEnum effect;
    private final AntispamSanctionGroupEnum group;
    private final int priority;

    AntispamSanctionEnum(int code, AntispamSanctionEffectEnum effect) {
        this(code, effect, null, 0);
    }

    AntispamSanctionEnum(int code, AntispamSanctionEffectEnum effect, AntispamSanctionGroupEnum group, int priority) {
        this.id = code;
        this.effect = effect;
        this.group = group;
        this.priority = priority;
    }

    @Override
    public int value() {
        return id;
    }

    public AntispamSanctionEffectEnum getEffect() {
        return effect;
    }

    public AntispamSanctionGroupEnum getGroup() {
        return group;
    }

    public int getPriority() {
        return priority;
    }

    public static final IntEnumResolver<AntispamSanctionEnum> R = IntEnumResolver.r(AntispamSanctionEnum.class);

    public static final Comparator<AntispamSanctionEnum> compareByEffectById =
            (s1, s2) -> {
                int res = AntispamSanctionEffectEnum.byEffect.compare(s1.effect, s2.effect);
                if (res != 0) {
                    return res;
                }
                return Integer.compare(s1.id, s2.id);
            };

    public static final Comparator<AntispamSanctionEnum> compareByPriority = Comparator
            .comparingInt(AntispamSanctionEnum::getPriority)
            .thenComparing(AntispamSanctionEnum::value);
}
