package ru.yandex.webmaster3.core.antispam.threats;

import com.fasterxml.jackson.annotation.JsonCreator;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;

import java.util.UUID;

/**
 * Данные для таски проверки свежедобавленного сайта на угрозы
 * Created by Oleg Bazdyrev on 09/08/2017.
 */
public class CheckForHostThreatsTaskData extends WorkerTaskData {

    public CheckForHostThreatsTaskData(WebmasterHostId hostId) {
        super(hostId);
    }

    @JsonCreator
    public CheckForHostThreatsTaskData(UUID taskId, WebmasterHostId hostId) {
        super(taskId, hostId);
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.CHECK_FOR_HOST_THREATS;
    }

    @Override
    public String getShortDescription() {
        return "Check added host " + getHostId() + " for threats";
    }
}
