package ru.yandex.webmaster3.core.blackbox;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author avhaliullin
 */
public class BlackboxQuery {
    public final String param;
    public final String value;

    private BlackboxQuery(String param, String value) {
        this.param = param;
        this.value = value;
    }

    public static BlackboxQuery byLogin(String login) {
        return new BlackboxQuery("login", login);
    }

    public static BlackboxQuery byUids(long... uids) {
        return byUids(Arrays.stream(uids).boxed());
    }

    public static BlackboxQuery byUids(Collection<Long> uids) {
        return byUids(uids.stream());
    }

    private static BlackboxQuery byUids(Stream<Long> uids) {
        return new BlackboxQuery("uid", uids.distinct().map(Object::toString).collect(Collectors.joining(",")));
    }
}
