package ru.yandex.webmaster3.core.blackbox;

/**
 * @author avhaliullin
 */
public abstract class GetEmailsType {
    private static class Simple extends GetEmailsType {
    }

    public static class TestOne extends GetEmailsType {
        private final String emailToTest;

        public TestOne(String emailToTest) {
            this.emailToTest = emailToTest;
        }

        public String getEmailToTest() {
            return emailToTest;
        }
    }

    public static GetEmailsType NONE = new Simple();
    public static GetEmailsType ALL = new Simple();
    public static GetEmailsType DEFAULT = new Simple();

    public static GetEmailsType testOne(String email) {
        return new TestOne(email);
    }
}
