package ru.yandex.webmaster3.core.blackbox;


import java.util.Set;

/**
 * @author avhaliullin
 */
public class OAuthClientInfo {
    private final Long uid;
    private final String clientName;
    private final String clientId;
    private final Set<Scope> scope;

    public OAuthClientInfo(Long uid, String clientName, String clientId, Set<Scope> scope) {
        this.uid = uid;
        this.clientName = clientName;
        this.clientId = clientId;
        this.scope = scope;
    }

    public Long getUid() {
        return uid;
    }

    public String getClientName() {
        return clientName;
    }

    public String getClientId() {
        return clientId;
    }

    public Set<Scope> getScope() {
        return scope;
    }

    public static class Scope {
        private final String service;
        private final String scope;

        public Scope(String service, String scope) {
            this.service = service;
            this.scope = scope;
        }

        public String getService() {
            return service;
        }

        public String getScope() {
            return scope;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Scope scope1 = (Scope) o;

            if (!service.equals(scope1.service)) return false;
            return scope.equals(scope1.scope);

        }

        @Override
        public int hashCode() {
            int result = service.hashCode();
            result = 31 * result + scope.hashCode();
            return result;
        }
    }
}
