package ru.yandex.webmaster3.core.blackbox;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author avhaliullin
 */
public class UserWithLogin {
    private final long userId;
    private final String login;

    @JsonCreator
    public UserWithLogin(@JsonProperty("userId") long userId,
                         @JsonProperty("login") String login) {
        this.userId = userId;
        this.login = login;
    }

    public long getUserId() {
        return userId;
    }

    public String getLogin() {
        return login;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        UserWithLogin userWithLogin = (UserWithLogin) o;

        if (userId != userWithLogin.userId) return false;
        if (!login.equals(userWithLogin.login)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = (int) (userId ^ (userId >>> 32));
        result = 31 * result + login.hashCode();
        return result;
    }
}
