package ru.yandex.webmaster3.core.blackbox.service;

/**
 * @author aherman
 */
public class BlackboxResponse<T> {
    private final T data;
    private final BlackboxStatus status;

    private BlackboxResponse(T data, BlackboxStatus status) {
        this.data = data;
        this.status = status;
    }

    public T getData() {
        return data;
    }

    public BlackboxStatus getStatus() {
        return status;
    }

    public boolean isUserLoggedIn() {
        return status == BlackboxStatus.VALID || status == BlackboxStatus.NEED_RESET;
    }

    static <T> BlackboxResponse<T> createError(BlackboxStatus blackboxStatus) {
        return new BlackboxResponse<T>(null, blackboxStatus);
    }

    static <T> BlackboxResponse<T> createData(T data) {
        return new BlackboxResponse<T>(data, BlackboxStatus.VALID);
    }
}
