package ru.yandex.webmaster3.core.checklist.data;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author avhaliullin
 */
public enum MicrodataDocStatus implements IntEnum {
    VALID(0),
    YANDEX_INVALID(1),
    WARNING(2),
    INVALID(3),
    ABORTED(4),
    NO_MARKUP(5),
    ;

    private final int value;

    MicrodataDocStatus(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static IntEnumResolver<MicrodataDocStatus> R = IntEnumResolver.r(MicrodataDocStatus.class);
}
