package ru.yandex.webmaster3.core.checklist.data;

import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * @author avhaliullin
 */
public enum MobileAuditResolution {
    @Description("Не удалось скачать морду")
    FAILED_TO_DOWNLOAD_BASE_URL(true),
    @Description("Морда не мобилопригодна")
    BASE_URL_NOT_MOBILE_FRIENDLY(true),
    @Description("Не удалось найти урлов для проверки")
    NO_INPUT_URLS(false),
    @Description("Не удалось скачать урлы для проверки")
    NO_DOWNLOADED_URLS(false),
    @Description("Удалось скачать слишком мало урлов для проверки")
    FEW_DOWNLOADED_URLS(false),
    @Description("Мало мобилопригодных страниц")
    FEW_MOBILE_FRIENDLY_URLS(false),
    @Description("Многие урлы них редиректят на одно и тоже (среди целей редиректов мало уникальных урлов)")
    FEW_UNIQUE_URLS(false),
    @Description("Морда редиректит куда-то на другой хост")
    BAD_TARGET_OWNER_FOR_BASE_URL(true),
    @Description("Проблема в контуре, пользователю не показываем")
    INTERNAL_ERROR(false),
    @Description("Проблема с подменами между мобильной и десктопной версиями сайта")
    NO_MOBILE_FROM_DESKTOP(false),
    ;

    private final boolean mordaProblem;

    MobileAuditResolution(boolean mordaProblem) {
        this.mordaProblem = mordaProblem;
    }

    public boolean isMordaProblem() {
        return mordaProblem;
    }
}
