package ru.yandex.webmaster3.core.checklist.data;

import java.util.Set;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author vsedaikina
 * 14.12.21
 */
public enum NotMobileFriendlyStatus implements IntEnum {
    @Description("Не мобилопригоден. Статус следует смотреть в resolution")
    NOT_MOBILE_FRIENDLY(1 << 0),
    @Description("Некорректный альтернативный url")
    BAD_LINK_ALTERNATE(1 << 1),
    @Description("Некорректная подмена url")
    BAD_HOST_REPLACED(1 << 2),
    ;
    private final int value;

    NotMobileFriendlyStatus(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public boolean isPartOf(int val) {
        return ((val & this.value()) == this.value());
    }

    public static int getAlertFlag(Set<NotMobileFriendlyStatus> set) {
        int alertFlag = 0;
        for (NotMobileFriendlyStatus status : set) {
            alertFlag |= status.value();
        }
        return alertFlag;
    }

    public static IntEnumResolver<NotMobileFriendlyStatus> R = IntEnumResolver.r(NotMobileFriendlyStatus.class);
}
