package ru.yandex.webmaster3.core.checklist.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author avhaliullin
 */
public enum SiteProblemSeverityEnum implements IntEnum {
    @Description("Фатальные проблемы")
    FATAL(0, 0),
    @Description("Критичные проблемы")
    CRITICAL(1, 5),
    @Description("Возможные проблемы")
    POSSIBLE_PROBLEM(2, 3),
    @Description("Рекомендации")
    RECOMMENDATION(3, 1),
    ;
    private final int value;
    private final int weight;

    SiteProblemSeverityEnum(int value, int weight) {
        this.value = value;
        this.weight = weight;
    }

    @Override
    public int value() {
        return value;
    }

    public int getWeight() {
        return weight;
    }

    public static final IntEnumResolver<SiteProblemSeverityEnum> R = IntEnumResolver.r(SiteProblemSeverityEnum.class);
}
