package ru.yandex.webmaster3.core.checklist.data;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author avhaliullin
 */
public enum SiteProblemState implements IntEnum {
    PRESENT(0, true),
    ABSENT(1, false),
    UNDEFINED(2, false),

    // проблема не применима к данному хосту, не отдавать ее фронтенду
    NOT_APPLICABLE(3, false)
    ;

    private final int value;
    private final boolean present;

    SiteProblemState(int value, boolean present) {
        this.value = value;
        this.present = present;
    }

    @Override
    public int value() {
        return value;
    }

    public boolean isPresent() {
        return present;
    }

    public static final IntEnumResolver<SiteProblemState> R = IntEnumResolver.r(SiteProblemState.class);
}
