package ru.yandex.webmaster3.core.checklist.data;

import java.util.List;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.IdUtils;

/**
 * @author avhaliullin
 */
public enum SiteProblemStorageType {
    REAL_TIME ,
    REAL_TIME_DOMAIN { // те же real_time проблемы, но с привязкой к домену, а не хосту. Обрезается www., m. http://, https://
        public List<WebmasterHostId> allPossibleHostsForProblem(WebmasterHostId hostId) {
            return IdUtils.allHostsForDomainWithM(hostId);
        }
    },
    REAL_TIME_DOMAIN_WITH_M { // те же real_time проблемы, для метрики.  Обрезается www., http://, https://
        public List<WebmasterHostId> allPossibleHostsForProblem(WebmasterHostId hostId) {
            return IdUtils.allHostsForDomain(hostId);
        }
    },
    REAL_TIME_OWNER {
        @Override
        public boolean shouldAlwaysUpdateProblem() {
            return true; // искать все хосты по оунеру дорого
        }
    },
    GENERATION_BASED {
        @Override
        public boolean shouldAlwaysUpdateProblem() {
            return true;
        }
    },
    FAVICON_PROBLEM,
    TURBO_PROBLEM {
        public List<WebmasterHostId> allPossibleHostsForProblem(WebmasterHostId hostId) {
            return IdUtils.allHostsForDomainWithM(hostId);
        }
    },
    HOST_PROBLEM,
    SITEMAP_PROBLEM,
    THREATS_PROBLEM;

    public List<WebmasterHostId> allPossibleHostsForProblem(WebmasterHostId hostId) {
        return List.of(hostId);
    }

    public boolean isRealTimeProblem() {
        return true;
    }

    public boolean shouldAlwaysUpdateProblem() {
        return false;
    }

}
