package ru.yandex.webmaster3.core.checklist.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.turbo.model.ban.TurboBanReason;
import ru.yandex.webmaster3.core.turbo.model.error.TurboErrorType;

/**
 * Пример бана турбо страницы
 * Created by Oleg Bazdyrev on 10/04/2018.
 */
public class TurboBanSample {

    private final String url;
    private final TurboBanReason reason;
    private final TurboErrorType error;

    public TurboBanSample(String url, TurboBanReason reason, TurboErrorType error) {
        this.url = url;
        this.reason = reason;
        this.error = error;
    }

    @Description("URL забаненной страницы")
    public String getUrl() {
        return url;
    }

    @Description("Причина бана")
    public TurboBanReason getReason() {
        return reason;
    }

    @Description("Ошибка, послужившая основанием для бана (может быть null)")
    public TurboErrorType getError() {
        return error;
    }
}
