package ru.yandex.webmaster3.core.checklist.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.AllArgsConstructor;
import lombok.Value;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.sitestructure.SearchUrlStatusEnum;

/**
 * Пример проблемного урла из турбо-фида
 * Created by Oleg Bazdyrev on 10/04/2018.
 */
@Value
@AllArgsConstructor(onConstructor_ = @JsonCreator)
public class TurboUrlErrorSample {

    @Description("URL проблемной страницы")
    String url;
    @Description("Фид, откуда эта страница взялась (может быть не всегда)")
    String feed;
    @Description("Какой статус страницы в поиске")
    SearchUrlStatusEnum urlStatus;

}
