package ru.yandex.webmaster3.core.checklist.data;

import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;

/**
 * Форматы плохой рекламы от Я.Браузера
 * Created by Oleg Bazdyrev on 30/11/2017.
 */
public enum YaBrowserBadAdFormat {

    DESKTOP_FULLSCR_ONLOAD_COUNT("desktop-fullscr-onload-count"),
    DESKTOP_POPUP_COUNT("desktop-popup-count"),
    DESKTOP_POPUP_CLOSE("desktop-popup-close"),
    DESKTOP_STICKY_BOT_BIG_CLOSE("desktop-sticky-bot-big-close"),
    DESKTOP_STICKY_TOP_BIG_NOCLOSE("desktop-sticky-top-big-noclose"),
    DESKTOP_AUDIO_AUTO("desktop-audio-auto"),
    DESKTOP_AUDIO_HOVER("desktop-audio-hover"),
    MOBILE_FULLSCR_ONLOAD_COUNT_AUTO("mobile-fullscr-onload-count-auto"),
    MOBILE_FULLSCR_ONLOAD_COUNT("mobile-fullscr-onload-count"),
    MOBILE_FULLSCR_MIDDLE_COUNT("mobile-fullscr-middle-count"),
    MOBILE_FULLSCR_MIDDLE_CLOSE("mobile-fullscr-middle-close"),
    MOBILE_AUDIO_AUTO("mobile-audio-auto"),
    ;

    private static final Map<String, YaBrowserBadAdFormat> formatsByRawId = new HashMap<>();

    static {
        for (YaBrowserBadAdFormat format : values()) {
            formatsByRawId.put(format.rawId, format);
        }
    }

    private final String rawId;

    YaBrowserBadAdFormat(String rawId) {
        this.rawId = rawId;
    }

    public String getRawId() {
        return rawId;
    }

    @Nullable
    public static YaBrowserBadAdFormat fromRawId(String rawId) {
        return formatsByRawId.get(rawId);
    }
}
