package ru.yandex.webmaster3.core.codes;

import ru.yandex.wmtools.common.util.http.YandexHttpStatus;

import java.util.HashSet;
import java.util.Set;

/**
 * @author aherman
 */
public class HttpHelper {
    public static Set<Integer> httpGroupToCodes(DownloadedHttpCodeGroup group) {
        Set<Integer> codes = new HashSet<>();
        for (YandexHttpStatus status : YandexHttpStatus.values()) {
            if (group.contains(status.getCode())) {
                codes.add(status.getCode());
            }
        }
        return codes;
    }

    public static Set<Integer> getCodesByGroup(ErrorGroupEnum group) {
        Set<Integer> codes = new HashSet<>();
        for (YandexHttpStatus status : YandexHttpStatus.values()) {
            if (group.contains(status.getCode())) {
                codes.add(status.getCode());
            }
        }
        return codes;
    }

    public static Set<Integer> getErrorCodes(HttpCodeGroup[] indicators, ErrorGroupEnum group) {
        Set<Integer> codes = new HashSet<>();
        for (HttpCodeGroup codeGroup : indicators) {
            for (int code : codeGroup.getCodesInternal()) {
                if (group.contains(code)) {
                    codes.add(code);
                }
            }
        }
        return codes;
    }

    public static boolean isIgnoredCode(int httpCode) {
        return /*httpCode == 0 || */httpCode == 23;
    }
}
