package ru.yandex.webmaster3.core.codes;

import ru.yandex.wmtools.common.util.http.YandexHttpStatus;

import java.util.Optional;

/**
 * Почему это все происходит: https://wiki.yandex-team.ru/jandekspoisk/interfejjsy/centrvebmastera/codyrobota/
 *
 * @author avhaliullin
 */
public class YandexHttpStatusUtil {
    public static Optional<String> yandexHttpStatus2View(YandexHttpStatus status) {
        if (status == YandexHttpStatus.EXT_HTTP_2021_CLEANPARAM) {
            return Optional.empty();
        }
        if (status == YandexHttpStatus.NEVER_DOWNLOADED){
            return Optional.of("N/a");
        }
        if ((status.value() >= 1000 && status.value() < 2000) ||
                (status.value() >= 3000)) {
            return Optional.empty();
        } else if (status.value() >= 2000 && status.value() < 3000) {
            return Optional.of("200");
        } else {
            return Optional.of(String.valueOf(status.value()));
        }
    }

    public static Optional<String> yandexHttpStatus2View(int status) {
        if (status < 1000) {
            return Optional.of(String.valueOf(status));
        }
        return yandexHttpStatus2View(YandexHttpStatus.parseCode(status));
    }
}
