package ru.yandex.webmaster3.core.data;

import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author aherman
 */
public abstract class BaseDataGeneration {
    private final DateTime createDate;
    private final DateTime closeDate;
    private final DateTime updateDate;

    private final GenerationState state;

    protected BaseDataGeneration(@NotNull DateTime createDate, DateTime closeDate, DateTime updateDate, GenerationState state) {
        this.createDate = createDate;
        this.closeDate = closeDate;
        this.updateDate = updateDate;
        this.state = state;
    }

    @NotNull
    public DateTime getCreateDate() {
        return createDate;
    }

    public DateTime getCloseDate() {
        return closeDate;
    }

    public DateTime getUpdateDate() {
        return updateDate;
    }

    public GenerationState getGenerationState() {
        return state;
    }

    public static enum GenerationState implements IntEnum{
        UNKNOWN(-1),

        OPENED(0),
        NEW(1),
        PUBLISHED(2),
        REVOKED(3),
        DELETED(4),
        ;

        GenerationState(int value) {
            this.value = value;
        }

        private final int value;

        @Override
        public int value() {
            return value;
        }

        public static final IntEnumResolver<GenerationState> R = IntEnumResolver.r(GenerationState.class);

        public static boolean canBeUsed(GenerationState state) {
            switch (state) {
                case NEW:
                case PUBLISHED:
                    return true;
            }
            return false;
        }
    }
}
