package ru.yandex.webmaster3.core.data;

import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

import ru.yandex.webmaster3.core.domain.HostDomainInfoService;

/**
 * @author aherman
 */
public class HostDomainInfo {
    private final String punycodeDomainName;
    private final int prefixEndPosition;
    private final int ownerStartPosition;

    public HostDomainInfo(String punycodeDomainName, int prefixEndPosition, int ownerStartPosition) {
        this.punycodeDomainName = punycodeDomainName;
        this.prefixEndPosition = prefixEndPosition;
        this.ownerStartPosition = ownerStartPosition;
    }

    @Nullable
    public String getPrefix() {
        if (prefixEndPosition > 0) {
            return punycodeDomainName.substring(0, prefixEndPosition);
        }
        return null;
    }

    @Nullable
    public String getOwner() {
        if (ownerStartPosition == HostDomainInfoService.HOSTNAME_WITHOUT_OWNER) {
            return null;
        }
        if (ownerStartPosition == HostDomainInfoService.HOSTNAME_IS_OWNER) {
            return punycodeDomainName;
        }
        return punycodeDomainName.substring(ownerStartPosition);
    }

    public String getPunycodeDomainName() {
        return punycodeDomainName;
    }

    public String getDomainMiddlePart() {
        if (prefixEndPosition > 0) {
            return StringUtils.substring(punycodeDomainName, prefixEndPosition + 1, ownerStartPosition - 1);
        } else {
            return StringUtils.substring(punycodeDomainName, 0, ownerStartPosition - 1);
        }
    }
}
