package ru.yandex.webmaster3.core.data;

import java.util.Locale;

/**
 * @author avhaliullin
 */
public enum L10nEnum {
    RU("ru", Locale.forLanguageTag("RU")),
    UK("uk", Locale.forLanguageTag("UK")),
    BE("be", Locale.forLanguageTag("BE")),
    KK("kk", Locale.forLanguageTag("KK")),
    TR("tr", Locale.forLanguageTag("TR")),
    EN("en", Locale.ENGLISH);

    private final String name;
    private final Locale locale;

    L10nEnum(String name, Locale locale) {
        this.name = name;
        this.locale = locale;
    }

    public String getName() {
        return name;
    }

    public Locale getLocale() {
        return locale;
    }
}
