package ru.yandex.webmaster3.core.data;

import java.util.UUID;

import com.google.common.hash.BloomFilter;
import org.joda.time.DateTime;

/**
 * @author aherman
 */
public class MirrorGeneration extends BaseDataGeneration {
    private final UUID mirrorGenerationId;
    private final BloomFilter<WebmasterHostId> bloomFilter;

    public MirrorGeneration(UUID mirrorGenerationId, DateTime createDate, DateTime closeDate, DateTime updateDate,
            GenerationState state, BloomFilter<WebmasterHostId> bloomFilter)
    {
        super(createDate, closeDate, updateDate, state);
        this.mirrorGenerationId = mirrorGenerationId;
        this.bloomFilter = bloomFilter;
    }

    public UUID getMirrorGenerationId() {
        return mirrorGenerationId;
    }

    public BloomFilter<WebmasterHostId> getBloomFilter() {
        return bloomFilter;
    }

    @Override
    public String toString() {
        return "MirrorGeneration{" +
                "id=" + mirrorGenerationId +
                ", state=" + getGenerationState().name() +
                '}';
    }
}
