package ru.yandex.webmaster3.core.data;

import java.util.Comparator;
import java.util.EnumMap;

/**
 * @author avhaliullin
 */
public class W3RegionInfo {
    private final Integer parentId;
    private final int id;
    private final int type;
    private final EnumMap<L10nEnum, String> names;
    private final String defaultName;
    private final boolean hidden;

    public W3RegionInfo(Integer parentId, int id, int type, EnumMap<L10nEnum, String> names, String defaultName, boolean hidden) {
        this.parentId = parentId;
        this.id = id;
        this.type = type;
        this.names = names;
        this.defaultName = defaultName;
        this.hidden = hidden;
    }

    public Integer getParentId() {
        return parentId;
    }

    public int getId() {
        return id;
    }

    public EnumMap<L10nEnum, String> getNames() {
        return names;
    }

    public int getType() {
        return type;
    }

    public String getDefaultName() {
        return defaultName;
    }

    public boolean isHidden() {
        return hidden;
    }

    @Override
    public String toString() {
        return "W3RegionInfo{" +
                "parentId=" + parentId +
                ", id=" + id +
                ", type=" + type +
                ", names=" + names +
                ", defaultName='" + defaultName + '\'' +
                ", hidden=" + hidden +
                '}';
    }

    public static final Comparator<W3RegionInfo> BY_ID = Comparator.comparingInt(W3RegionInfo::getId);
}
