package ru.yandex.webmaster3.core.data;

import java.util.UUID;

import lombok.ToString;
import org.joda.time.DateTime;

/**
 * @author aherman
 */
@ToString
public class WebmasterHostGeneration {
    private final WebmasterHostId hostId;
    private final UUID generationId;
    private final DateTime updateDate;
    private final DateTime addedDate;

    public WebmasterHostGeneration(WebmasterHostId hostId, UUID generationId, DateTime updateDate, DateTime addedDate) {
        this.hostId = hostId;
        this.generationId = generationId;
        this.updateDate = updateDate;
        this.addedDate = addedDate;
    }

    public WebmasterHostGeneration(WebmasterHostId hostId, UUID generationId) {
        this.hostId = hostId;
        this.generationId = generationId;
        this.updateDate = null;
        this.addedDate = null;
    }


    public WebmasterHostId getHostId() {
        return hostId;
    }

    public UUID getGenerationId() {
        return generationId;
    }

    public DateTime getUpdateDate() {
        return updateDate;
    }

    public DateTime getAddedDate() {
        return addedDate;
    }

    public boolean isExists() {
        return true;
    }

    public boolean isEmpty() {
        return generationId == null;
    }

    public static WebmasterHostGeneration createEmpty(WebmasterHostId hostId) {
        return new WebmasterHostGeneration(hostId, null, null, null) {
            @Override
            public boolean isExists() {
                return false;
            }

            @Override
            public boolean isEmpty() {
                return true;
            }
        };
    }
}
