package ru.yandex.webmaster3.core.data;

import org.joda.time.DateTime;

/**
 * @author avhaliullin
 */
public class WhoisInfo {
    private final DateTime domainExpirationDate;
    private final DateTime parseDate;
    private final boolean whoisFound;

    public WhoisInfo(DateTime domainExpirationDate, DateTime parseDate, boolean whoisFound) {
        this.domainExpirationDate = domainExpirationDate;
        this.parseDate = parseDate;
        this.whoisFound = whoisFound;
    }

    public boolean isWhoisFound() {
        return whoisFound;
    }

    public DateTime getDomainExpirationDate() {
        return domainExpirationDate;
    }

    public DateTime getParseDate() {
        return parseDate;
    }
}
