package ru.yandex.webmaster3.core.delurl;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author aherman
 */
public enum DelurlState implements IntEnum {
    UNKNOWN(0, false),

    NEW(1, false),
    ACCEPTED(2, true),
    REJECTED(3, true),
    ERROR(4, true),
    IN_PROGRESS(5, false),
    ;

    private final int value;
    private final boolean isFinal;

    DelurlState(int value, boolean isFinal) {
        this.value = value;
        this.isFinal = isFinal;
    }

    @Override
    public int value() {
        return value;
    }

    public boolean isFinal() {
        return isFinal;
    }

    public static final IntEnumResolver<DelurlState> R = IntEnumResolver.r(DelurlState.class);
}
