package ru.yandex.webmaster3.core.delurl;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskPriority;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;

import java.util.List;

/**
 * Created by Oleg Bazdyrev on 09/10/2017.
 */
public class ProcessDelurlRequestTaskData extends WorkerTaskData {

    private final List<DelUrlRequest> requests;

    public ProcessDelurlRequestTaskData(WebmasterHostId hostId, WorkerTaskPriority taskPriority,
                                        List<DelUrlRequest> requests) {
        super(hostId, taskPriority);
        this.requests = requests;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.PROCESS_DELURL_REQUEST;
    }

    @Override
    public String getShortDescription() {
        return null;
    }

    public List<DelUrlRequest> getRequests() {
        return requests;
    }
}
