package ru.yandex.webmaster3.core.digest;

import ru.yandex.webmaster3.core.checklist.data.SiteProblemSeverityEnum;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;

/**
 * Created by Oleg Bazdyrev on 27/07/2018.
 */
public class DigestChecklistUtil {

    public static boolean showProblemIfPresent(SiteProblemTypeEnum problem) {
        return !problem.isDisabled() &&
                (problem.getSeverity() == SiteProblemSeverityEnum.FATAL
                        || problem.getSeverity() == SiteProblemSeverityEnum.CRITICAL);
    }

    public static boolean showProblemIfFixed(SiteProblemTypeEnum problem) {
        return !problem.isDisabled() &&
                (problem.getSeverity() == SiteProblemSeverityEnum.FATAL
                        || problem.getSeverity() == SiteProblemSeverityEnum.CRITICAL
                        || problem == SiteProblemTypeEnum.NO_METRIKA_COUNTER);
    }
}
