package ru.yandex.webmaster3.core.digest.graphics.draw;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.webmaster3.core.digest.graphics.draw.data.Polyline;
import ru.yandex.webmaster3.core.digest.graphics.draw.data.SecondaryAxisX;

import java.util.*;

/**
 * Created by ifilippov5 on 16.09.17.
 */
public class ChartGeneratorUtil {
    private static final Logger log = LoggerFactory.getLogger(ChartGeneratorUtil.class);

    public static String generateSvg(Polyline pastSeries, Polyline currentSeries, List<SecondaryAxisX> secondaryAxisX, ChartSettings chartSettings) {
        String svg = String.format(Locale.ROOT, "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 %d %d\" width=\"%d\" height=\"%d\">\n" +
                "<rect class=\"background\" x=\"0\" y=\"0\" width=\"%d\" height=\"%d\" fill=\"%s\"></rect>\n" +
                generateGrid(secondaryAxisX, chartSettings) +
                generateSeries(Arrays.asList(pastSeries, currentSeries),
                                Arrays.asList(chartSettings.getPastSeriesColor(), chartSettings.getCurrentSeriesColor()).iterator(), chartSettings) +
                generateLabels(secondaryAxisX, chartSettings) +
                "<rect class=\"border\" x=\"0\" y=\"0\" width=\"%d\" height=\"%d\" fill=\"none\" stroke=\"%s\" stroke-width=\"1\"></rect>\n" +
                "</svg>",
                chartSettings.getChartWidth(), chartSettings.getChartHeight(), chartSettings.getChartWidth(), chartSettings.getChartHeight(),
                chartSettings.getChartWidth(), chartSettings.getChartHeight(), chartSettings.getBackgroundColor(),
                chartSettings.getChartWidth() - 1, chartSettings.getChartHeight() - 1, chartSettings.getGridColor());

        return svg;
    }

    private static String generateGrid(List<SecondaryAxisX> secondaryAxisX, ChartSettings chartSettings) {
        StringBuilder gridSvg = new StringBuilder(String.format(Locale.ROOT, "<g class=\"grid\" fill=\"none\" stroke=\"%s\">\n", chartSettings.getGridColor()));
        for (SecondaryAxisX axis : secondaryAxisX.subList(0, secondaryAxisX.size())) {
            gridSvg.append(String.format(Locale.ROOT, "<line x1=\"0\" y1=\"%.2f\" x2=\"%d\" y2=\"%.2f\"></line>\n",
                    axis.getYCoordinate(),
                    chartSettings.getChartWidth(),
                    axis.getYCoordinate()
                    ));
        }
        gridSvg.append("</g>\n");
        return gridSvg.toString();
    }

    private static String generateSeries(List<Polyline> series, Iterator<String> colors, ChartSettings chartSettings) {
        StringBuilder seriesSvg = new StringBuilder(String.format(Locale.ROOT, "<g class=\"series-group\" fill=\"none\" stroke-width=\"%.2f\">\n", chartSettings.getStrokeWidth()));
        for (Polyline polyline : series) {
            seriesSvg.append(String.format(Locale.ROOT, "<polyline points=\"%s\" stroke=\"%s\"></polyline>\n",
                    polyline.toString(),
                    colors.next()
            ));
        }
        seriesSvg.append("</g>\n");
        return seriesSvg.toString();
    }

    private static String generateLabels(List<SecondaryAxisX> secondaryAxisX, ChartSettings chartSettings) {
        StringBuilder labelsSvg = new StringBuilder(String.format(Locale.ROOT, "<g class=\"axis\" font-size=\"%s\" font-family=\"%s\">\n", chartSettings.getLabelFontSize(), chartSettings.getLabelFontFamily()));
        for (SecondaryAxisX axis : secondaryAxisX.subList(0, secondaryAxisX.size() - 1)) {
            labelsSvg.append(String.format(Locale.ROOT,
                    "<rect class=\"text-bg\" x=\"%.2f\" y=\"%.2f\" width=\"%.2f\" height=\"%d\" rx=\"%d\" ry=\"%d\" fill=\"%s\" opacity=\"0.5\"></rect>\n",
                    axis.getLabel().getRectCoordinate().getX(),
                    axis.getLabel().getRectCoordinate().getY(),
                    axis.getLabel().getWidth(),
                    chartSettings.getLabelHeight(),
                    chartSettings.getLabelRx(),
                    chartSettings.getLabelRy(),
                    chartSettings.getBackgroundColor()
            ));
            labelsSvg.append(String.format(Locale.ROOT,
                    "<text x=\"%.2f\" y=\"%.2f\">%s</text>\n",
                    axis.getLabel().getTextCoordinate().getX(),
                    axis.getLabel().getTextCoordinate().getY(),
                    axis.getLabel().getValue()
            ));
        }
        labelsSvg.append("</g>\n");
        return labelsSvg.toString();
    }
}
