package ru.yandex.webmaster3.core.digest.graphics.draw.data;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

/**
 * Created by ifilippov5 on 15.09.17.
 */
public class Label {
    private Point textCoordinate;
    private Point rectCoordinate;
    private final double width;
    private final String value;

    private Label(Point textCoordinate, Point rectCoordinate, double width, String value) {
        this.textCoordinate = textCoordinate;
        this.rectCoordinate = rectCoordinate;
        this.width = width;
        this.value = value;
    }

    public Point getTextCoordinate() {
        return textCoordinate;
    }

    public Point getRectCoordinate() {
        return rectCoordinate;
    }

    public double getWidth() {
        return width;
    }

    public String getValue() {
        return value;
    }

    /**
     * Разделяет число по разрядам пробелами.
     * @example 10000 -> 10 000
     * @param {Long} value Любой текст содержащий числа
     * @returns {String}
     */
    public static String formatNumber(Long value) {
        if (value == null) {
            return "";
        }
        DecimalFormat df = new DecimalFormat();
        df.setGroupingSize(3);
        df.setGroupingUsed(true);
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setGroupingSeparator(' ');
        df.setDecimalFormatSymbols(dfs);

        return df.format(value);
    }

    private static final int RECT_SHIFT_Y = 10;
    private static final int NUMBER_PADDING = 3;
    private static final double SYMBOL_WIDTH = 5.55;

    public static Label createLabel(Point coordinate, Long value) {
        Point rect = new Point(coordinate.getX() - NUMBER_PADDING, coordinate.getY() - RECT_SHIFT_Y);
        String valueStr = formatNumber(value);
        double width = (double)valueStr.length() * SYMBOL_WIDTH + NUMBER_PADDING * 2.0;
        return new Label(
                coordinate,
                rect,
                width,
                valueStr);
    }
}
