package ru.yandex.webmaster3.core.digest.graphics.draw.data;

import java.util.Locale;

/**
 * Created by ifilippov5 on 15.09.17.
 */
public class Point {
    private double x;
    private double y;

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Point scale(double shiftX, double coeffX, double shiftY, double coeffY, double marginY, double height, double width) {
        return new Point((x - shiftX) * coeffX,
                Math.min(Math.max((y - shiftY) * coeffY + marginY, 2), height - 2));
    }

    public double getX() {
        return x;
    }

    public double getY() {
        return y;
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "%.2f", x) + "," + String.format(Locale.ROOT, "%.2f", y);
    }
}
