package ru.yandex.webmaster3.core.digest.graphics.draw.data;

import ru.yandex.webmaster3.core.digest.graphics.draw.data.Point;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by ifilippov5 on 15.09.17.
 */
public class Polyline {
    private List<Point> points;

    public Polyline() {
        points = new ArrayList<>();
    }

    public Polyline(List<Point> points) {
        this.points = points;
    }

    public void addPoint(Point point) {
        points.add(point);
    }

    public void addPoint(int x, int y) {
        points.add(new Point(x, y));
    }

    public List<Point> getPoints() {
        return points;
    }

    @Override
    public String toString() {
        return points.stream().map(Object::toString).collect(Collectors.joining(" "));
    }
}
